//	CDialogQuick3.c

#include "string.h"
#include "stdio.h"
#include "Utils.h"
#include "MainEvent.h"
#include "CDialog3Button.h"

#include "CDialogQuick3.h"

typedef struct {
	Dlog_ItemIDType			i_itemHit;
	Boolean					i_doneB;
} Dlog_Quick3Rec;

static	Dlog_Quick3Rec		S_Quick3Answer;

void				ResetQuick3Dialog(Dlog_ItemIDType itemID)
{
	S_Quick3Answer.i_itemHit	= itemID;
	S_Quick3Answer.i_doneB		= itemID != kDlog_3Button_ItemID_NONE;
}

static	Boolean		Quick3_S_CB(short buttonID, void *cbData)
{
	Dlog_Quick3Rec		*deleteAnswerP = (Dlog_Quick3Rec *)cbData;
	
	deleteAnswerP->i_itemHit	= buttonID;
	deleteAnswerP->i_doneB		= TRUE;
	
	return TRUE;
}

static char		GetKeyEquivChar(Dlog_ActionType action, char *strZ)
{
	char		keyChar = 0;
	
	if (action == Dlog_Action_NONE) {
		Boolean		isOkCancelB = TRUE;
		
		if (strZ) {
			isOkCancelB = 
				strcmp(strZ, "OK") == 0
				|| strcmp(strZ, "Cancel") == 0;
		}
		
		if (!isOkCancelB) {
			keyChar = strZ[0];
		}
	}
	
	return keyChar;
}

static		void	SetUpButton(
	Dlog3ButtonParamRec		*dialogParamsP,
	Dlog_ItemIDType			button, 
	Dlog_ItemStrType		stringID, 
	char					*strZ, 
	Dlog_ActionType			action)
{
	Dlog3ButtonRec			*buttonP;

	buttonP = &dialogParamsP->buttonA[stringID];
	if (strZ) {
		strcpy(buttonP->nameAC, strZ);
		buttonP->visibleB		= TRUE;
	} else {
		strcpy(buttonP->nameAC, "");
		buttonP->visibleB		= FALSE;
	}
	
	buttonP->keyEquivChar	= GetKeyEquivChar(action, strZ);
	buttonP->buttonID		= button;
	buttonP->actionType		= action;
}

Dlog_ItemIDType		Quick3Button(
	char	*titleZ, 
	char	*verbageZ, 
	char	*button1Z,	Dlog_ActionType		action1, 
	char	*button2Z,	Dlog_ActionType		action2, 
	char	*button3Z,	Dlog_ActionType		action3)
{
	CDialog3Button			*dialogP;
	Dlog3ButtonParamRec		dialogParams;
	
	ResetQuick3Dialog(kDlog_3Button_ItemID_NONE);

	strcpy(dialogParams.titleAC, titleZ);
	strcpy(dialogParams.verbageAC, verbageZ);
	
	dialogParams.DoneCB = Quick3_S_CB;
	dialogParams.cbData	= &S_Quick3Answer;

	/***************/
	SetUpButton(
		&dialogParams, 
		kDlog_3Button_ItemID_BUTTON_1, 
		kDlog_3Button_ItemStr_BUTTON_1, 
		button1Z, action1);
	/***************/
	SetUpButton(
		&dialogParams, 
		kDlog_3Button_ItemID_BUTTON_2, 
		kDlog_3Button_ItemStr_BUTTON_2, 
		button2Z, action2);
	/***************/
	SetUpButton(
		&dialogParams, 
		kDlog_3Button_ItemID_BUTTON_3, 
		kDlog_3Button_ItemStr_BUTTON_3, 
		button3Z, action3);
	
	/***************/	
	dialogP = Show3ButtonDialog(&dialogParams);
	if (dialogP) {
		do {
			HandleOneEvent(10);
		} while (!S_Quick3Answer.i_doneB);
	}
	
	return S_Quick3Answer.i_itemHit;
}
